################################################################################
##                         Portfolio Analysis                                 ##
##                       - Nikolay Robinzonov -                               ##
################################################################################
library(R.oo)
library(R.matlab) # ?R.matlab
library(reshape)
library(ggplot2)
datei <- readMat("Rweek.mat")
rweek <- data.frame(datei$Rweek)
names(rweek) <- c("sp500", "ftse", "dax")
time <- seq(as.Date("1984/1/1"), as.Date("2005/8/1"), by="week")
molten <- melt(cbind(rweek,time), id="time")
levels(molten$variable) <- c("S&P500", "FTSE", "DAX")
qplot(time, value, geom="line", colour=variable, data=molten) +
  facet_grid(variable ~ . ) + ylab(expression(log(P[t]) - log(P[t-1]))) +
  xlab(NULL) + scale_x_date(minor_breaks = "year") +
  theme(legend.position = "none")
ggsave("returns.pdf", width=9, height=6.5)

## b) #########################################################################
## (i)
(mu <- apply(rweek[1:500,], 2, mean))
(sigma <- cov(rweek[1:500,]))

## (ii)
ones <- rep(1,length(mu))
xup <- solve(sigma) %*% ones
a <- as.numeric(mu %*% solve(sigma) %*% mu)
b <- as.numeric(ones %*% solve(sigma) %*% mu)
c <- as.numeric(ones %*% solve(sigma) %*% ones)
d <- a*c-b^2
(xGMVP <- xup/c)
(muGMVP <- b/c)
(x1 <- xGMVP + (1/0.2) * solve(sigma) %*% (mu - muGMVP * ones))
(x2 <- xGMVP + (1/2) * solve(sigma) %*% (mu - muGMVP * ones))

sigmaMVS <- function(m)  sqrt((a-2*b*m+c*m^2)/d)

## Investor 1
(mu1 <- as.numeric(t(x1)%*%mu))
(sig1 <- sigmaMVS(mu1))
## Investor 2
(mu2 <- as.numeric(t(x2)%*%mu))
(sig2 <- sigmaMVS(mu2))

## plot the mean-variance space
pdf("MVS.pdf", width=6,height=6)
myseq <- seq(0,0.3,by=0.0001)
plot(sigmaMVS(myseq), myseq, type="l", xlim=c(1.89,1.93),ylim=c(0.23,0.26),
     xlab=expression(sigma), ylab=expression(mu), axes=FALSE)
axis(1, col="gray80")
axis(2, col="gray80")
lines(x=c(0,sigmaMVS(mu1),sigmaMVS(mu1)),y=c(mu1,mu1,0),lty=2,col=2)
lines(x=c(0,sigmaMVS(mu2),sigmaMVS(mu2)),y=c(mu2,mu2,0),lty=3,col=4)
lines(x=c(0,sigmaMVS(muGMVP),sigmaMVS(muGMVP)),y=c(muGMVP,muGMVP,0),lty=1,col=3)
legend("topright", col = c(2,4,3), lty=c(2,3,1), box.col="gray80",
       legend = c("Investor 1", "Investor 2","GMVP"))

## Expected utility function
U <- function(theta, x, mu = mu, sigma = sigma){
  -exp(-theta * t(x) %*% mu + 0.5 * theta^2 * t(x) %*% sigma %*% x) # E[U]
}
## Indifference curve
M <- function(theta, u, sigma) (0.5 * theta^2 * sigma^2 - log(-u)) / theta

## Draw the indifference curves of both investors
## Investor 1
u1 <- as.numeric(U(theta=0.2, x=x1, mu=mu, sigma=sigma))
xsig <- seq(1.90, 1.92, length=100)
lines(xsig, M(theta=0.2, u=u1, sigma = xsig), col="gray50")

## Investor 2
u2 <- as.numeric(U(theta=2, x=x2, mu=mu, sigma=sigma))
xsig <- seq(1.90, 1.905, length=100)
lines(xsig, M(theta=2, u=u2, sigma=xsig), lty=1, col="gray50")

## Zoom in
plot(sigmaMVS(myseq),myseq,type="l", xlim=c(1.9,1.91),ylim=c(0.24,0.25),
     xlab=expression(sigma), ylab=expression(mu), axes=FALSE)
axis(1, col="gray80")
axis(2, col="gray80")
lines(x=c(0,sigmaMVS(mu1),sigmaMVS(mu1)),y=c(mu1,mu1,0),lty=2,col=2)
lines(x=c(0,sigmaMVS(mu2),sigmaMVS(mu2)),y=c(mu2,mu2,0),lty=3,col=4)
lines(x=c(0,sigmaMVS(b/c),sigmaMVS(b/c)),y=c(b/c,b/c,0),lty=1,col=3)

dev.off()



## (iii)
as.vector(x1); as.vector(x2)
newdata <- rweek[501:1127,]
r1 <- as.vector(t(x1)%*%t(newdata))
r2 <- as.vector(t(x2)%*%t(newdata))
mean(r1); mean(r2)
sigmaMVS(mean(r1))
sigmaMVS(mean(r2))
cor(rweek)                              # initial correlation matrix
cor(newdata)                            # out-of-sample correlation matrix
