%%%%%%%%%%%%%%%%%%%%%%
% Portfolio Analysis
% Fabian Spanhel
%%%%%%%%%%%%%%%%%%%%%%
close all
datei = load('Rweek.mat'); % loading data
rweek = datei.Rweek;

%% b) %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (i)
mu = mean(rweek(1:500,:));
mu = mu'; % transforming row vector to column vector
sigma = cov(rweek(1:500,:));

% (ii)
unit = ones(length(mu),1); % the variable ones in R is in Matlab called unit because ones is a function in Matlab which creates this unit vector
xup = sigma\unit; % sigma\mu equals inv(sigma)*mu but is more efficient
a = mu'*(sigma\mu); 
b = unit'*(sigma\mu);
c = unit'*(sigma\unit);
d = a*c-b^2;
xGMVP = xup/c;
muGMVP = b/c;
x1 = xGMVP+1/0.2*(sigma\(mu-muGMVP*unit));
x2 = xGMVP+1/2*(sigma\(mu-muGMVP*unit));

sigmaMVS = @(m) sqrt((a-2*b*m+c*m.^2)/d); % define a local function in Matlab, these functions are called anonymous functions, we need .^2 to compute elementwise the power of m if m is a vector

mu1 = x1'*mu;
sigma1 = sigmaMVS(mu1);
mu2 = x2'*mu;
sigma2 = sigmaMVS(mu2);

%% plot the mean-variance space

myseq = 0:0.0001:0.3;
plot(sigmaMVS(myseq),myseq,'Color','k')
axis([1.89 1.93 0.23 0.26])
xlabel('\sigma')
ylabel('\mu')
handle1 = line([0 sigma1 sigma1],[mu1 mu1 0],'LineStyle',':','Color','r');
handle2 = line([0 sigma2 sigma2],[mu2 mu2 0],'LineStyle',':','Color','b');
handle3 = line([0 sigmaMVS(muGMVP) sigmaMVS(muGMVP)],[muGMVP muGMVP 0],'LineStyle','-','Color','g');
legend([handle1 handle2 handle3],'Investor 1','Investor 2','GMVP','Location','NorthWest')

plot(sigmaMVS(myseq),myseq,'Color','k')
axis([1.9 1.91 0.24 0.25])
xlabel('\sigma')
ylabel('\mu')
handle1 = line([0 sigma1 sigma1],[mu1 mu1 0],'LineStyle',':','Color','r');
handle2 = line([0 sigma2 sigma2],[mu2 mu2 0],'LineStyle',':','Color','b');
handle3 = line([0 sigmaMVS(muGMVP) sigmaMVS(muGMVP)],[muGMVP muGMVP 0],'LineStyle','-','Color','g');
legend([handle1 handle2 handle3],'Investor 1','Investor 2','GMVP','Location','NorthWest')

%% (iii)
newdata = rweek(501:1127,:);
r1 = newdata*x1;
r2 = newdata*x2;
newmu1 = mean(r1);
newmu2 = mean(r2);
newsigma1 = sigmaMVS(newmu1);
newsigma2 = sigmaMVS(newmu2);
corr(rweek)
corr(newdata)
